# SafeNet Access Exchange High Availability Cluster MultiNode Setup

This project sets up a High Availability (HA) cluster for SafeNet Access Exchange (SAE) using MySQL and Nginx. The setup consists of three SAE nodes, a MySQL database, and an Nginx load balancer.

## Project Structure

```
SAE_HA_Cluster_MultiNode/
├── README.md                                  # This documentation file
├── .env                                       # Environment variables (credentials & config)
├── .env.example                               # Template for .env file
├── nginx.conf                                 # Nginx Load Balancer configuration
├── cache-ispn-jdbc-ping-tcp.xml               # Infinispan cache configuration
├── SAE_NODE1_DB_LB-docker-compose.yml         # Node 1 Config (DB, LB, SAE)
├── SAE_NODE2-docker-compose.yml               # Node 2 Config (SAE Worker)
├── SAE_NODE3-docker-compose.yml               # Node 3 Config (SAE Worker)
└── certs/                                     # SSL Certificates
    ├── cert.pem                               # Public Certificate
    └── privkey.pem                            # Private Key
```

## Services Breakdown

### Node 1 (SAE_NODE1_DB_LB)
*   **`sae-node1`**: SafeNet Access Exchange (SAE) instance.
*   **`mysql`**: MySQL Database server (Backend for SAE).
*   **`nginx-lb`**: Nginx Reverse Proxy / Load Balancer (Entry point).

### Node 2 (SAE_NODE2)
*   **`sae-node2`**: SafeNet Access Exchange (SAE) instance.

### Node 3 (SAE_NODE3)
*   **`sae-node3`**: SafeNet Access Exchange (SAE) instance.

## Architecture

The cluster is distributed across three nodes. All nodes communicate via JGroups for cache replication using the host network.

*   **Node 1**: Hosts the Database, Load Balancer, and SAE Node 1.
*   **Node 2**: SAE Node 2.
*   **Node 3**: SAE Node 3.


## Prerequisites

*   Docker and Docker Compose installed on all nodes.
*   Firewall rules allowing traffic on ports:
    *   `80`, `443` (Nginx on Node 1, external access)
    *   `3306` (MySQL on Node 1, internal access from Node 2 & 3)
    *   `7800` (JGroups, internal cluster communication between all nodes)
    *   `8080` (SAE, internal access from LB on Node 1)

Note: This deployment assumes that a highly available MySQL database is already deployed, either as a managed service from a cloud provider or by following the instructions in the "MySQL Cluster Deployment (for High-Availability)" section. You will need to update the KC_DB_URL environment variable in your .env file with the connection string for your database.


## Deployment Steps

Follow these steps to deploy the complete solution.

### Step 1: Configure Environment Variables
1.  On **all nodes**, create a `.env` file from the example:
    ```bash
    cp .env.example .env
    ```
2.  Edit `.env` and set the following:
    *   **Passwords**: Set strong passwords for `MYSQL_PASSWORD`, `MYSQL_ROOT_PASSWORD`, and `KEYCLOAK_ADMIN_PASSWORD`.
    *   **Node IPs**: Update `SAE_NODE1_IP`, `SAE_NODE2_IP`, and `SAE_NODE3_IP` with the actual IP addresses of your servers.
    *   **Hostname**: Ensure `KC_HOSTNAME` matches your domain name.

### Step 2: Configure SSL Certificates
1.  On **Node 1** (where Nginx runs), navigate to the project directory.
2.  Place your valid SSL certificate and private key in the `certs/` folder:
    *   Replace `certs/cert.pem` with your public certificate.
    *   Replace `certs/privkey.pem` with your private key.

### Step 3: Configure Nginx
1.  Open `nginx.conf` on **Node 1**.
2.  Replace the placeholders `<SAE_NODE1_IP>`, `<SAE_NODE2_IP>`, and `<SAE_NODE3_IP>` and  `<SAE_HOST_NAME>` ; with the actual IP addresses of your nodes and Domain Name (Same as KC_HOSTNAME in .env file).

### Step 4: Deploy Node 1 (Primary)
On **Node 1**, run:
```bash
docker-compose -f SAE_NODE1_DB_LB-docker-compose.yml up -d
```
*   Verify that MySQL and Nginx are running.
*   Verify that `sae-node1` starts up correctly.

### Step 5: Deploy Worker Nodes
On **Node 2**, run:
```bash
docker-compose -f SAE_NODE2-docker-compose.yml up -d
```

On **Node 3**, run:
```bash
docker-compose -f SAE_NODE3-docker-compose.yml up -d
```

### Step 6: Verification
1.  Access the application via the configured hostname (e.g., `https://sae.example.com`).
2.  Check logs to ensure nodes have discovered each other via JGroups.

## Security Notes

*   **Firewall**: Ensure your OS firewall blocks external access to ports 3306, 7800, and 8080.
*   **Secrets**: Keep your `.env` file secure.
*   **SSL**: Ensure your certificates are valid and trusted.
